function Symbols = Eight_PSK_Modulation(data_input,Eb)
            
    %gray coded 8-PSK
    N=length(data_input);
    Symbols = [];  
    
    % Compare incoming bits with all possible symbols and assign appropriate angles with
    % the help of complex exponentials
    
    % For-loop steps with 3 since 3 bits = 1 symbol
    
    
 for i=1:3:N-2
     
     % Picks out the current symbol    
    tmp_segment = data_input(i:i+2);
    
    
    % Assign appropriate angles for the current symbol
    % THIS IS GRAY CODED
    
    if tmp_segment == [0 0 0];
        
       tmp_symbol = exp(1i*0);
        
    elseif tmp_segment == [0 0 1];
        
         tmp_symbol = exp(1i*(pi/4));
        
    elseif tmp_segment == [0 1 1] ;
        
        tmp_symbol = exp(1i*(2*pi/4));
        
    elseif tmp_segment == [0 1 0];
        
        tmp_symbol = exp(1i*(3*pi/4));
       
    elseif tmp_segment == [1 1 0];
        
        tmp_symbol = exp(1i*(4*pi/4));
        
    elseif tmp_segment == [1 1 1];
        
        tmp_symbol = exp(1i*(5*pi/4));
        
    elseif tmp_segment == [1 0 1];
        
        tmp_symbol = exp(1i*(6*pi/4));
        
    elseif tmp_segment == [1 0 0];    
        
        tmp_symbol = exp(1i*(7*pi/4));
    end
    
    % Collecting all the symbols expressed as complex exponentials
    % in an output vector
    
    Symbols = [Symbols, tmp_symbol];
    
 end
    Symbols = Symbols*sqrt(3*Eb);
end


% POSSIBLE M-ary PSK implementation THIS DOES NOT WORK WITH GRAY CODING
%     n = log2(m);
% for k=1:n:N;
%     
%     tmp_segment = new_b(k:k+n-1);
%     decimal_multiple = bin2dec(num2str(tmp_segment));%% Converts binary value to decimal
%     tmp_symbol =exp(1i*decimal_multiple*(2*pi/m))%% multiply with corresponding phase
%    
%     Symbols = [Symbols, tmp_symbol];
% 
% end
% end
